
####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was dwarfs-config.cmake.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../../" ABSOLUTE)

# Use original install prefix when loaded through a "/usr move"
# cross-prefix symbolic link such as /lib -> /usr/lib.
get_filename_component(_realCurr "${CMAKE_CURRENT_LIST_DIR}" REALPATH)
get_filename_component(_realOrig "/usr/lib64/cmake/dwarfs" REALPATH)
if(_realCurr STREQUAL _realOrig)
  set(PACKAGE_PREFIX_DIR "/usr")
endif()
unset(_realOrig)
unset(_realCurr)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

macro(check_required_components _NAME)
  foreach(comp ${${_NAME}_FIND_COMPONENTS})
    if(NOT ${_NAME}_${comp}_FOUND)
      if(${_NAME}_FIND_REQUIRED_${comp})
        set(${_NAME}_FOUND FALSE)
      endif()
    endif()
  endforeach()
endmacro()

####################################################################################

include(CMakeFindDependencyMacro)

set_and_check(DWARFS_INCLUDE_DIR "${PACKAGE_PREFIX_DIR}/include")
set_and_check(DWARFS_CMAKE_DIR "${PACKAGE_PREFIX_DIR}/lib64/cmake/dwarfs")

set(DWARFS_PREFIX_DIR "${PACKAGE_PREFIX_DIR}")

find_package(PkgConfig)

if( AND ) # APPLE AND USE_HOMEBREW_LIBARCHIVE
  find_program(HOMEBREW_EXE brew)
  execute_process(
    COMMAND ${HOMEBREW_EXE} --prefix libarchive
    OUTPUT_VARIABLE LIBARCHIVE_PREFIX
    OUTPUT_STRIP_TRAILING_WHITESPACE)
  list(PREPEND CMAKE_PREFIX_PATH ${LIBARCHIVE_PREFIX})
endif()

find_dependency(Threads REQUIRED)
find_dependency(fmt CONFIG REQUIRED)
find_dependency(gflags CONFIG REQUIRED)
find_dependency(Boost 1.67.0 REQUIRED CONFIG
                COMPONENTS chrono context filesystem iostreams program_options regex system thread
                OPTIONAL_COMPONENTS process)
pkg_check_modules(LIBCRYPTO REQUIRED IMPORTED_TARGET libcrypto>=3.0.0)
pkg_check_modules(LIBARCHIVE REQUIRED IMPORTED_TARGET libarchive>=3.6.0)
pkg_check_modules(XXHASH REQUIRED IMPORTED_TARGET libxxhash>=0.8.1)
pkg_check_modules(ZSTD REQUIRED IMPORTED_TARGET libzstd>=1.4.8)

set(LIBDWARFS_WITH_CPPTRACE )
set(LIBDWARFS_WITH_LIBLZ4 1)
set(LIBDWARFS_WITH_LIBLZMA 1)
set(LIBDWARFS_WITH_LIBBROTLI (1 AND 1))
set(LIBDWARFS_WITH_FLAC 1)
set(LIBDWARFS_WITH_JEMALLOC 1)

if(LIBDWARFS_WITH_CPPTRACE)
  find_dependency(cpptrace CONFIG REQUIRED)
endif()

if(LIBDWARFS_WITH_LIBLZ4)
  pkg_check_modules(LIBLZ4 REQUIRED IMPORTED_TARGET liblz4>=1.9.3)
endif()

if(LIBDWARFS_WITH_LIBLZMA)
  pkg_check_modules(LIBLZMA REQUIRED IMPORTED_TARGET liblzma>=5.2.5)
endif()

if(LIBDWARFS_WITH_LIBBROTLI)
  pkg_check_modules(LIBBROTLIDEC REQUIRED IMPORTED_TARGET libbrotlidec>=1.0.9)
  pkg_check_modules(LIBBROTLIENC REQUIRED IMPORTED_TARGET libbrotlienc>=1.0.9)
endif()

if(LIBDWARFS_WITH_FLAC)
  pkg_check_modules(FLAC REQUIRED IMPORTED_TARGET flac++>=1.4.2)
endif()

if(LIBDWARFS_WITH_JEMALLOC)
  pkg_check_modules(JEMALLOC REQUIRED IMPORTED_TARGET jemalloc>=5.2.1)
endif()

if (NOT TARGET dwarfs::dwarfs_common)
  include("${DWARFS_CMAKE_DIR}/dwarfs-targets.cmake")
endif()

check_required_components(dwarfs)
